<?php
   /*
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreNotifiche extends VisualizzatoreComponente {
        private $impostazioniRicerca;
        
        function __construct($db) {
            parent::__construct($db);
        }
        
        function creaSezione($dati) {
            $idSezione = "";
            $classeSezione = "";
            if($dati["idSezione"]!="") {
                $idSezione = "id=\"{$dati["idSezione"]}\"";
            } 
            if($dati["classeSezione"]!="") {
                $classeSezione = "class=\"{$dati["classeSezione"]}\"";
            }
            $classeContainer = ($dati["aTuttaLarghezza"]=="si") ? "" : "container";
            echo"<section  $idSezione $classeSezione >
                    <div class=\"$classeContainer\">
                        <div class=\"row\">";
                            $this->generaContenutoSezione($dati);
                    echo"</div>
                    </div>
                </section>";
        }
        
        function generaContenutoSezione($dati) {
            ?>
                <div class="col-12">
                    <?php 
                        $parametriRicerca = array("idUtente"=>$_SESSION["geecomUser_id"],"letta"=>"no");
                        $parametri        = array("tabella"=>"geec_notifiche", "elementiPerPagina"=>25,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
                        $ricerca   = new Ricerca(parent::getDb(), $parametri, $this->impostazioniRicerca, "");
                        $ricerca->setOrdinamento(" ORDER BY id DESC");
                        $ris     = $ricerca->eseguiRicerca(1);
                        if($ris->num_rows==0) {
                            echo"<div class=\"alert card\" role=\"alert\">
                                Non sono presenti notifiche al momento
                            </div>";
                        }
                        else {
                            while($notifica = $ris->fetch_assoc()) {
                                $dataCreazione = date("d/m/Y H:i:s",strtotime($notifica["dataCreazione"]));
                                echo"<div class=\"alert card alert-dismissible fade show\" role=\"alert\">
                                    <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                        <span aria-hidden=\"true\">&times;</span>
                                    </button>
                                    <p>{$notifica["testo"]}</p>";
                                    if($notifica["link"]!="") {
                                        echo"<a class=\"btn btn-outline-primary btn-sm\" href=\"{$notifica["link"]}\">Vedi</a>";
                                    }
                                    echo"<hr>
                                    <p class=\"small mb-0 text-right\"><i class=\"far fa-clock mr-2\"></i>$dataCreazione</p>
                                </div>";
                            }
                        }

                        // setto le notifiche di questo utente come lette, assumo che se una persona va nella pagina delle notifiche 
                        $queryNotificheLette = "UPDATE geec_notifiche SET letta='si' WHERE idUtente = {$_SESSION["geecomUser_id"]}";
                        parent::getDb()->eseguiQueryLettura($queryNotificheLette);
                    ?>
                </div>
            <?php
        }
        
        // getter & setter
        public function getImpostazioniRicerca() {
            return $this->impostazioniRicerca;
        }

        public function setImpostazioniRicerca($impostazioniRicerca) {
            $this->impostazioniRicerca = $impostazioniRicerca;
        }

    }